package com.UHF.scanlable;

import java.io.File;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import com.UHF.scanlable.R;
import com.rfid.serialport.SerialPortFinder;

import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;
public class Connect232 extends Activity {


		private static final String TAG = "COONECTRS232";
		private static String devport = "/dev/ttyHSL2";
		private static final boolean DEBUG = true;
		private TextView mConectButton;
			
	
		private TextView   mBaud9600View, mBaud19200View,  mBaud38400View,mBaud57600View,mBaud115200View;


		
		private int mPosPort = -1;
		
		private SerialPortFinder mSerialPortFinder;
		
		String[] entries = null;
		String[] entryValues = null;
		private ArrayAdapter<String> spacom; 
		private int baud = 57600;
		
		@Override
		protected void onCreate(Bundle savedInstanceState) {
			super.onCreate(savedInstanceState);
			setContentView(R.layout.activity_connect232);

			
			mConectButton = (TextView) findViewById(R.id.textview_connect);

			mBaud9600View = (TextView) findViewById(R.id.baud_9600);
			mBaud19200View =  (TextView) findViewById(R.id.baud_19200);
			mBaud38400View =  (TextView) findViewById(R.id.baud_38400);
			mBaud57600View =  (TextView) findViewById(R.id.baud_57600);
			mBaud115200View =  (TextView) findViewById(R.id.baud_115200);
			baud = 57600;
			mBaud9600View.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					baud = 9600;
				}
			});
			
			mBaud19200View.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					baud = 19200;
				}
			});
			mBaud38400View.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					baud = 38400;
				}
			});
			mBaud57600View.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					baud = 57600;
				}
			});
			mBaud115200View.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					baud = 115200;
				}
			});
			

			mConectButton.setOnClickListener(new OnClickListener() {
				
				@Override
				public void onClick(View v) {
					try {
						int result = Reader.rrlib.Connect("/dev/ttyMT0", baud);
						if(result==0){
							Intent intent;
							intent = new Intent().setClass(Connect232.this, MainActivity.class);
							startActivity(intent);
						}
						else
						{
							Toast.makeText(
									getApplicationContext(),
									getString(R.string.openport_failed),
									Toast.LENGTH_SHORT).show();
						}
					}catch (Exception e) 
					{
						Toast.makeText(
								getApplicationContext(),
								getString(R.string.openport_failed),
								Toast.LENGTH_SHORT).show();
					}
				}
			});
		}
		

	

		public boolean onKeyDown(int keyCode, KeyEvent event) {
			if (keyCode == KeyEvent.KEYCODE_BACK) {
				
				finish();

				return true;
			}
			return super.onKeyDown(keyCode, event);
		}
		
		@Override
		protected void onDestroy() {
			// TODO Auto-generated method stub
			super.onDestroy();
		}

}
